# UGM ⇒ Gravity • Simulation 2 — Shapiro-like Delay (log law)

This bundle contains the **as-run** artifacts, manifests, audits, figures, and a **verification script**
that recomputes the fit and amplitude ratio from CSVs and checks every required audit flag.

## Contents
- `manifests/`: control DAG + study windows/meshes/tolerances
- `hinges/`: OFF-scene hinge measurements and hash
- `catalog/`: Earth-ring catalog constant and hash
- `prereg/`: pre-registered ratios & hashes
- `runs/`: CSV outputs (`shapiro_delay.csv`, `recentering.csv`)
- `audits/`: all MUST-PASS audits as JSON + provenance
- `figures/`: `panel_B_shapiro.png`, `panel_R_recenter.png`, `wow_onepager.png`
- `logs/`: environment snapshot
- `SHA256SUMS.txt`: repo-wide hashes

## Quick verify
```
python3 verify.py
```
You should see all checks **PASS**, including:
- log-law fit (R² ≥ 0.95) & residual runs-test (p ≥ 0.05) on both meshes
- mesh certification (ΔA/A ≤ 0.02 and shape corr ≥ 0.99)
- ratio test: K_Δt ∈ [3.800, 4.200] for both meshes
- re-centering slope & ratio-invariance within tolerance
- neutrality, SR integrity (cone leakage = 0), isotropy/monotone, no-signalling
- diagnostics-leak guard and ties-only RNG audit
- all CSV `claimable=true`, and all per-row hashes match shipped files

## Notes
This package is designed to be **skeptic-ready**. It does not retune or re-run the control;
it verifies the shipped outputs against the declared contract and windows, with all hashes consistent.
